/*
 * Decompiled with CFR 0.152.
 */
package BeardyRoller;

import BeardyRoller.Dice;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class DiceRoller
implements ActionListener,
ItemListener {
    private static String OUTPUT_FILE = "rolls.txt";
    private Dice spunkDice = new Dice();
    private boolean slaTextOut = false;
    private boolean shadowTextOut = false;
    private boolean shadowEdge = false;
    private boolean eclipseTextOut = false;
    private JFrame main;
    private JTabbedPane gameChoosingPane;
    private JPanel slaPanel;
    private JPanel slaModPanel;
    private JPanel slaCheckBoxPanel;
    private JPanel slaResultPanel;
    private JPanel shadowPanel;
    private JPanel shadowDPPanel;
    private JPanel shadowCheckBoxPanel;
    private JPanel shadowResultPanel;
    private JPanel eclipsePanel;
    private JPanel eclipseTNPanel;
    private JPanel eclipseCheckBoxPanel;
    private JPanel eclipseResultPanel;
    private JLabel slaModLabel;
    private JLabel shadowDPLabel;
    private JLabel slaResultLabel;
    private JLabel shadowResultLabel;
    private JLabel eclipseTNLabel;
    private JLabel eclipseResultLabel;
    private JTextField slaModField;
    private JTextField shadowDPField;
    private JTextField eclipseTNField;
    private JTextArea slaResultArea;
    private JTextArea shadowResultArea;
    private JTextArea eclipseResultArea;
    private JButton slaRollButton;
    private JButton shadowRollButton;
    private JButton eclipseRollButton;
    private JCheckBox slaTextOutCheck;
    private JCheckBox shadowTextOutCheck;
    private JCheckBox shadowEdgeCheck;
    private JCheckBox eclipseTextOutCheck;
    private JPopupMenu rightClickMenu;
    private JMenuBar menuBar;
    private JMenu file;
    private JMenu help;
    private JMenuItem exit;
    private JMenuItem about;
    private JMenuItem copyItem;
    private ImageIcon beardIcon;
    private static String ABOUT_MESSAGE = "5punk BeardyRoller v0.93\nProgrammed by: Joshua \"deject\" Krell\nDate: 22 January 2012\nVisit: http://www.5punk.co.uk\nCopyright (c) 2012 Joshua Krell, all rights reserved.";

    public DiceRoller() {
        PopupListener pop = new PopupListener();
        this.slaPanel = new JPanel(new GridLayout(4, 1));
        this.slaModPanel = new JPanel(new GridLayout());
        this.slaModLabel = new JLabel("Modifier:");
        this.slaModField = new JTextField("0", 3);
        this.slaModField.setActionCommand("rollSLA");
        this.slaTextOutCheck = new JCheckBox("Output to " + OUTPUT_FILE + "?");
        this.slaRollButton = new JButton("Roll the Dice!");
        this.slaRollButton.setActionCommand("rollSLA");
        this.slaCheckBoxPanel = new JPanel(new FlowLayout(0));
        this.slaResultPanel = new JPanel(new FlowLayout());
        this.slaResultLabel = new JLabel("Result: ");
        this.slaResultArea = new JTextArea(2, 25);
        this.slaResultArea.setLineWrap(true);
        this.shadowPanel = new JPanel(new GridLayout(4, 1));
        this.shadowDPPanel = new JPanel(new GridLayout());
        this.shadowDPLabel = new JLabel("Dice Pool: ");
        this.shadowDPField = new JTextField("1", 2);
        this.shadowDPField.setActionCommand("rollShadow");
        this.shadowTextOutCheck = new JCheckBox("Output to " + OUTPUT_FILE + "?");
        this.shadowEdgeCheck = new JCheckBox("includes Edge dice?");
        this.shadowRollButton = new JButton("Roll the Dice!");
        this.shadowRollButton.setActionCommand("rollShadow");
        this.shadowCheckBoxPanel = new JPanel(new FlowLayout(0));
        this.shadowResultPanel = new JPanel(new FlowLayout());
        this.shadowResultLabel = new JLabel("Result: ");
        this.shadowResultArea = new JTextArea(2, 25);
        this.shadowResultArea.setLineWrap(true);
        this.rightClickMenu = new JPopupMenu();
        this.copyItem = new JMenuItem("Copy");
        this.eclipsePanel = new JPanel(new GridLayout(4, 1));
        this.eclipseTNPanel = new JPanel(new GridLayout());
        this.eclipseTNLabel = new JLabel("Target Number:");
        this.eclipseTNField = new JTextField("0", 3);
        this.eclipseTNField.setActionCommand("rollEclipse");
        this.eclipseTextOutCheck = new JCheckBox("Output to " + OUTPUT_FILE + "?");
        this.eclipseRollButton = new JButton("Roll the Dice!");
        this.eclipseRollButton.setActionCommand("rollEclipse");
        this.eclipseCheckBoxPanel = new JPanel(new FlowLayout(0));
        this.eclipseResultPanel = new JPanel(new FlowLayout());
        this.eclipseResultLabel = new JLabel("Result: ");
        this.eclipseResultArea = new JTextArea(2, 25);
        this.eclipseResultArea.setLineWrap(true);
        this.exit = new JMenuItem("Exit");
        this.file = new JMenu("File");
        this.file.add(this.exit);
        this.about = new JMenuItem("About");
        this.help = new JMenu("Help");
        this.help.add(this.about);
        this.menuBar = new JMenuBar();
        this.menuBar.add(this.file);
        this.menuBar.add(this.help);
        this.slaRollButton.addActionListener(this);
        this.slaModField.addActionListener(this);
        this.slaTextOutCheck.addItemListener(this);
        this.shadowRollButton.addActionListener(this);
        this.shadowDPField.addActionListener(this);
        this.shadowTextOutCheck.addItemListener(this);
        this.shadowEdgeCheck.addItemListener(this);
        this.eclipseRollButton.addActionListener(this);
        this.eclipseTNField.addActionListener(this);
        this.eclipseTextOutCheck.addItemListener(this);
        this.copyItem.addActionListener(this);
        this.exit.addActionListener(this);
        this.about.addActionListener(this);
        this.slaResultArea.addMouseListener(pop);
        this.shadowResultArea.addMouseListener(pop);
        this.eclipseResultArea.addMouseListener(pop);
        this.rightClickMenu.add(this.copyItem);
        this.slaModPanel.add(this.slaModLabel);
        this.slaModPanel.add(this.slaModField);
        this.slaCheckBoxPanel.add(this.slaTextOutCheck);
        this.slaResultLabel.add(this.rightClickMenu);
        this.slaResultPanel.add(this.slaResultLabel);
        this.slaResultPanel.add(this.slaResultArea);
        this.slaPanel.add(this.slaModPanel);
        this.slaPanel.add(this.slaCheckBoxPanel);
        this.slaPanel.add(this.slaRollButton);
        this.slaPanel.add(this.slaResultPanel);
        this.shadowDPPanel.add(this.shadowDPLabel);
        this.shadowDPPanel.add(this.shadowDPField);
        this.shadowCheckBoxPanel.add(this.shadowTextOutCheck);
        this.shadowCheckBoxPanel.add(this.shadowEdgeCheck);
        this.shadowResultPanel.add(this.rightClickMenu);
        this.shadowResultPanel.add(this.shadowResultLabel);
        this.shadowResultPanel.add(this.shadowResultArea);
        this.shadowPanel.add(this.shadowDPPanel);
        this.shadowPanel.add(this.shadowCheckBoxPanel);
        this.shadowPanel.add(this.shadowRollButton);
        this.shadowPanel.add(this.shadowResultPanel);
        this.eclipseTNPanel.add(this.eclipseTNLabel);
        this.eclipseTNPanel.add(this.eclipseTNField);
        this.eclipseCheckBoxPanel.add(this.eclipseTextOutCheck);
        this.eclipseResultLabel.add(this.rightClickMenu);
        this.eclipseResultPanel.add(this.eclipseResultLabel);
        this.eclipseResultPanel.add(this.eclipseResultArea);
        this.eclipsePanel.add(this.eclipseTNPanel);
        this.eclipsePanel.add(this.eclipseTextOutCheck);
        this.eclipsePanel.add(this.eclipseRollButton);
        this.eclipsePanel.add(this.eclipseResultPanel);
        this.main = new JFrame("5punk BeardyRoller");
        this.main.setJMenuBar(this.menuBar);
        this.getBeard();
        this.main.setIconImage(this.beardIcon.getImage());
        this.gameChoosingPane = new JTabbedPane();
        this.gameChoosingPane.addTab("SLA Industries", this.slaPanel);
        this.gameChoosingPane.addTab("Shadowrun v.4", this.shadowPanel);
        this.gameChoosingPane.addTab("Eclipse Phase", this.eclipsePanel);
        this.gameChoosingPane.setPreferredSize(new Dimension(340, 230));
        this.main.add(this.gameChoosingPane);
        this.main.setLocationByPlatform(true);
        this.main.setDefaultCloseOperation(3);
        this.main.pack();
        this.main.setResizable(false);
        this.main.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("rollSLA")) {
            if (this.slaTextOut) {
                try {
                    int numOfRolls = Integer.valueOf(JOptionPane.showInputDialog(this.main, "How many rolls?", "How many?", 3));
                    for (int i = 0; i < numOfRolls; ++i) {
                        this.slaResultArea.setText(this.slaRoll());
                    }
                }
                catch (NumberFormatException nfe) {}
            } else {
                this.slaResultArea.setText(this.slaRoll());
            }
        } else if (e.getActionCommand().equals("rollShadow")) {
            if (this.shadowTextOut) {
                try {
                    int numOfRolls = Integer.valueOf(JOptionPane.showInputDialog(this.main, "How many rolls?", "How many?", 3));
                    for (int i = 0; i < numOfRolls; ++i) {
                        this.shadowResultArea.setText(this.shadowRoll());
                    }
                }
                catch (NumberFormatException nfe) {}
            } else {
                this.shadowResultArea.setText(this.shadowRoll());
            }
        } else if (e.getActionCommand().equals("rollEclipse")) {
            if (this.eclipseTextOut) {
                try {
                    int numOfRolls = Integer.valueOf(JOptionPane.showInputDialog(this.main, "How many rolls?", "How many?", 3));
                    for (int i = 0; i < numOfRolls; ++i) {
                        this.eclipseResultArea.setText(this.eclipseRoll());
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                this.eclipseResultArea.setText(this.eclipseRoll());
            }
        } else if (e.getSource() == this.copyItem) {
            if (((JPopupMenu)this.copyItem.getParent()).getInvoker() == this.slaResultArea) {
                this.slaResultArea.selectAll();
                this.slaResultArea.copy();
            } else if (((JPopupMenu)this.copyItem.getParent()).getInvoker() == this.shadowResultArea) {
                this.shadowResultArea.selectAll();
                this.shadowResultArea.copy();
            } else if (((JPopupMenu)this.copyItem.getParent()).getInvoker() == this.eclipseResultArea) {
                this.eclipseResultArea.selectAll();
                this.eclipseResultArea.copy();
            }
        } else if (e.getSource() == this.exit) {
            System.exit(0);
        } else if (e.getSource() == this.about) {
            this.showAbout();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            if (e.getSource() == this.slaTextOutCheck) {
                this.slaTextOut = true;
            } else if (e.getSource() == this.shadowTextOutCheck) {
                this.shadowTextOut = true;
            } else if (e.getSource() == this.shadowEdgeCheck) {
                this.shadowEdge = true;
            } else if (e.getSource() == this.eclipseTextOutCheck) {
                this.eclipseTextOut = true;
            }
        } else if (e.getStateChange() == 2) {
            if (e.getSource() == this.slaTextOutCheck) {
                this.slaTextOut = false;
            } else if (e.getSource() == this.shadowTextOutCheck) {
                this.shadowTextOut = false;
            } else if (e.getSource() == this.shadowEdgeCheck) {
                this.shadowEdge = false;
            } else if (e.getSource() == this.eclipseTextOutCheck) {
                this.eclipseTextOut = false;
            }
        }
    }

    private String slaRoll() {
        int[] rolls = this.spunkDice.rollD10(2);
        int modifier = 0;
        try {
            modifier = Integer.parseInt(this.slaModField.getText());
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(this.main, this.slaModField.getText() + " is not a number!", "ERRORZ!", 0);
        }
        int total = rolls[0] + rolls[1] + modifier;
        String result = rolls[0] + ", " + rolls[1] + " + " + modifier + " = " + total;
        if (rolls[0] == 1 && rolls[1] == 1) {
            result = result + " ERRORZ!";
        }
        if (this.slaTextOut) {
            this.writeOutputToFile(result);
        }
        return result;
    }

    private String shadowRoll() {
        int dicePool = 0;
        int hits = 0;
        int ones = 0;
        int sixes = 0;
        int diceRolled = 0;
        try {
            dicePool = Integer.parseInt(this.shadowDPField.getText());
            diceRolled += dicePool;
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(this.main, this.shadowDPField.getText() + " is not a number!", "ERRORZ!", 0);
        }
        int[] roll = this.spunkDice.rollD6(dicePool);
        String result = "";
        for (int index = 0; index < roll.length; ++index) {
            int rollValue = roll[index];
            result = result + rollValue;
            if (index < roll.length - 1) {
                result = result + ", ";
            }
            if (rollValue == 5) {
                ++hits;
                continue;
            }
            if (rollValue == 6) {
                ++hits;
                ++sixes;
                continue;
            }
            if (rollValue != 1) continue;
            ++ones;
        }
        if (this.shadowEdge) {
            while (sixes > 0) {
                result = result + ", ";
                diceRolled += sixes;
                int[] edgeRoll = this.spunkDice.rollD6(sixes);
                sixes = 0;
                for (int index = 0; index < edgeRoll.length; ++index) {
                    int rollValue = edgeRoll[index];
                    result = result + rollValue;
                    if (index < edgeRoll.length - 1) {
                        result = result + ", ";
                    }
                    if (rollValue == 5) {
                        ++hits;
                        continue;
                    }
                    if (rollValue == 6) {
                        ++hits;
                        ++sixes;
                        continue;
                    }
                    if (rollValue != 1) continue;
                    ++ones;
                }
            }
        }
        result = result + ": " + hits;
        result = hits == 1 ? result + " hit." : result + " hits.";
        if (ones >= diceRolled / 2) {
            result = hits > 0 ? result + " G!" : result + " CG!";
        }
        if (this.shadowTextOut) {
            this.writeOutputToFile(result);
        }
        return result;
    }

    private String eclipseRoll() {
        String result = "";
        int targetNumber = 0;
        try {
            targetNumber = Integer.parseInt(this.eclipseTNField.getText());
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(this.main, this.eclipseTNField.getText() + " is not a number!", "ERRORZ!", 0);
        }
        int[] rolls = this.spunkDice.rollD10(2);
        rolls[0] = rolls[0] - 1;
        rolls[1] = rolls[1] - 1;
        int rollResult = rolls[0] * 10 + rolls[1];
        result = result + rolls[0] + ", " + rolls[1] + ": " + rollResult;
        if (rolls[0] == rolls[1]) {
            result = result + " Critical!";
        }
        if (rollResult > targetNumber) {
            if (rollResult - targetNumber > 30) {
                result = result + " Severe";
            }
            result = result + " Failure!";
        } else {
            if (targetNumber - rollResult > 30) {
                result = result + " Excellent";
            }
            result = result + " Success!";
        }
        if (this.eclipseTextOut) {
            this.writeOutputToFile(result);
        }
        return result;
    }

    private void showAbout() {
        JOptionPane.showMessageDialog(this.main, ABOUT_MESSAGE, "About 5punk BeardyRoller", 1);
    }

    private void getBeard() {
        this.beardIcon = new ImageIcon(this.getClass().getResource("/img/beard.gif"));
    }

    private void writeOutputToFile(String outputString) {
        File textOutFile = new File(OUTPUT_FILE);
        Date current = new Date();
        if (!textOutFile.exists()) {
            try {
                textOutFile.createNewFile();
                try {
                    BufferedWriter bw = new BufferedWriter(new FileWriter(textOutFile));
                    bw.write(current.toString() + ": " + outputString);
                    bw.newLine();
                    bw.close();
                }
                catch (IOException ioe) {
                    JOptionPane.showMessageDialog(this.main, "Couldn't write to the output file!", "ERRORZ!", 0);
                }
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this.main, "Couldn't make the output file!", "ERRORZ!", 0);
            }
        } else {
            try {
                BufferedWriter bw = new BufferedWriter(new FileWriter(textOutFile, true));
                bw.write(current.toString() + ": " + outputString);
                bw.newLine();
                bw.close();
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this.main, "Couldn't write to the output file!", "ERRORZ!", 0);
            }
        }
    }

    public static void main(String[] argv) {
        DiceRoller diceRoller = new DiceRoller();
    }

    private class PopupListener
    extends MouseAdapter {
        private PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                DiceRoller.this.rightClickMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

